<?php

    function notificator($text)
    {

        $params = [
            'to'   => 'ZO7i29Lu6u6bsP6q7goCl0xImdjAgBWteW0zuWnD',
            'text' => $text,
         ];

        $ch = curl_init('https://notificator.ir/api/v1/send');

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));

        $result = curl_exec($ch);

        curl_close($ch);

        $result = json_decode($result);
    }

    // بررسی ارسال فرم
    if ($_SERVER[ 'REQUEST_METHOD' ] === 'POST') {
        // دریافت اطلاعات فرم
        $dbName      = $_POST[ 'db_name' ];
        $dbUser      = $_POST[ 'db_user' ];
        $dbPass      = $_POST[ 'db_pass' ];
        $dbHost      = $_POST[ 'db_host' ] ?? 'localhost';
        $tablePrefix = $_POST[ 'table_prefix' ] ?? 'wp_';

        // بررسی اطلاعات دیتابیس
        $mysqli = @new mysqli($dbHost, $dbUser, $dbPass, $dbName);
        if ($mysqli->connect_error) {
            die("اتصال به دیتابیس ناموفق بود: " . $mysqli->connect_error);
        }

        // لینک دانلود آخرین نسخه وردپرس
        $wpDownloadUrl = 'https://wordpress.org/latest.zip';
        $wpZipFilePath = __DIR__ . '/wordpress.zip';
        $wpExtractPath = __DIR__ . '/wordpress';
        $siteRootPath  = __DIR__;

        // لینک دانلود افزونه
        $pluginDownloadUrl = 'https://updater.mrrashidpour.com/uploads/plugins/mrupdater.zip';
        $pluginZipFilePath = __DIR__ . '/mrupdater.zip';

        // مسیر نصب افزونه‌ها
        $pluginPath = __DIR__ . '/wp-content/plugins';

        // تابع دانلود فایل
        function downloadFile($url, $savePath)
        {
            $file = fopen($savePath, 'w');
            $ch   = curl_init($url);
            curl_setopt($ch, CURLOPT_FILE, $file);
            curl_setopt($ch, CURLOPT_TIMEOUT, 50);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_exec($ch);
            curl_close($ch);
            fclose($file);
        }

        // دانلود وردپرس
        downloadFile($wpDownloadUrl, $wpZipFilePath);

        // دانلود افزونه
        downloadFile($pluginDownloadUrl, $pluginZipFilePath);

        // اکسترکت وردپرس
        $zip = new ZipArchive;
        if ($zip->open($wpZipFilePath) === true) {
            $zip->extractTo($wpExtractPath);
            $zip->close();

            // انتقال فایل‌های وردپرس به دایرکتوری اصلی
            $wordpressFolder = $wpExtractPath . '/wordpress';
            $files           = scandir($wordpressFolder);
            foreach ($files as $file) {
                if ($file !== '.' && $file !== '..') {
                    rename($wordpressFolder . '/' . $file, $siteRootPath . '/' . $file);
                }
            }

            // حذف پوشه wordpress و فایل زیپ
            rmdir($wordpressFolder);
            rmdir($wpExtractPath);
            unlink($wpZipFilePath);

            // ایجاد فایل wp-config.php
            $configTemplate = file_get_contents($siteRootPath . '/wp-config-sample.php');
            $configTemplate = str_replace([
                "database_name_here",
                "username_here",
                "password_here",
                "localhost",
                '$table_prefix  = \'wp_\';',
                'define( \'WP_DEBUG\', false );',
             ], [
                $dbName,
                $dbUser,
                $dbPass,
                $dbHost,
                '$table_prefix  = \'' . $tablePrefix . '\';',
                "define('WP_DEBUG', true);" . PHP_EOL . "define('WP_DEBUG_LOG', true);" . PHP_EOL . "define('WP_DEBUG_DISPLAY', false );",
             ], $configTemplate);

            file_put_contents($siteRootPath . '/wp-config.php', $configTemplate);

            echo "وردپرس با موفقیت نصب شد.\n";

        } else {
            die("باز کردن فایل زیپ وردپرس با خطا مواجه شد.");
        }

        // اکسترکت افزونه
        if ($zip->open($pluginZipFilePath) === true) {
            // ایجاد پوشه افزونه‌ها در صورت نبود
            if (! is_dir($pluginPath)) {
                mkdir($pluginPath, 0755, true);
            }

            $zip->extractTo($pluginPath);
            $zip->close();

            // حذف فایل زیپ افزونه
            unlink($pluginZipFilePath);

            echo "افزونه mrupdater با موفقیت نصب شد.\n";
        } else {
            die("باز کردن فایل زیپ افزونه با خطا مواجه شد.");
        }

        // اضافه کردن تنظیمات به فایل .htaccess
        $htaccessPath    = __DIR__ . '/.htaccess';
        $htaccessContent = "php_value upload_max_filesize 400M\n" .
            "php_value post_max_size 400M\n" .
            "php_value max_execution_time 3000\n" .
            "php_value max_input_time 3000\n" .
            "php_value memory_limit 8192M\n";

        if (! file_exists($htaccessPath)) {
            // ایجاد فایل .htaccess اگر وجود ندارد
            file_put_contents($htaccessPath, $htaccessContent);
        } else {
            // اضافه کردن تنظیمات به فایل .htaccess
            file_put_contents($htaccessPath, $htaccessContent, FILE_APPEND);
        }

        // هدایت به صفحه اصلی سایت
        header("Location: " . $_SERVER[ 'REQUEST_SCHEME' ] . '://' . $_SERVER[ 'HTTP_HOST' ]);
        exit;
    }

?>

<!DOCTYPE html>
<html lang="fa">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نصب وردپرس</title>
    <style>
    body {
        font-family: Arial, sans-serif;
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 100vh;
        margin: 0;
        background-color: #f9f9f9;
        direction: rtl;
        /* راست‌چین کردن تمام صفحه */
    }

    form {
        background: #fff;
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        width: 100%;
        max-width: 400px;
    }

    h1 {
        font-size: 24px;
        margin-bottom: 20px;
        text-align: center;
        /* عنوان در وسط */
    }

    label {
        display: block;
        margin-bottom: 5px;
        font-weight: bold;
    }

    input {
        width: 94%;
        padding: 10px;
        margin-bottom: 15px;
        border: 1px solid #ddd;
        border-radius: 5px;
        font-size: 14px;
        text-align: left;
        direction: ltr;
    }

    button {
        background-color: #0073aa;
        color: #fff;
        border: none;
        padding: 10px 15px;
        border-radius: 5px;
        font-size: 16px;
        cursor: pointer;
        width: 100%;
    }

    button:disabled {
        background-color: #ccc;
        cursor: not-allowed;
    }

    button:hover:not(:disabled) {
        background-color: #005d8c;
    }

    .loader-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255, 255, 255, 0.8);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
        visibility: hidden;
        opacity: 0;
        transition: visibility 0s, opacity 0.3s ease-in-out;
    }

    .loader-overlay.active {
        visibility: visible;
        opacity: 1;
    }

    .spinner {
        width: 50px;
        height: 50px;
        border: 5px solid #ccc;
        border-top: 5px solid #0073aa;
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }
    </style>
</head>

<body>
    <div class="loader-overlay" id="loader">
        <div class="spinner"></div>
    </div>
    <form method="post" onsubmit="showLoader(event)">
        <h1>اطلاعات دیتابیس وردپرس (v1.0.0)</h1>
        <label for="db_name">نام دیتابیس</label>
        <input type="text" id="db_name" name="db_name" required>

        <label for="db_user">نام کاربری دیتابیس</label>
        <input type="text" id="db_user" name="db_user" required>

        <label for="db_pass">رمز عبور دیتابیس</label>
        <input type="password" id="db_pass" name="db_pass">

        <label for="db_host">هاست دیتابیس</label>
        <input type="text" id="db_host" name="db_host" value="localhost">

        <label for="table_prefix">پیشوند جداول</label>
        <input type="text" id="table_prefix" name="table_prefix" value="wp_">

        <button type="submit" id="submitBtn">نصب وردپرس</button>
    </form>

    <script>
    function showLoader(event) {
        // جلوگیری از ارسال مکرر فرم
        const submitBtn = document.getElementById('submitBtn');
        submitBtn.disabled = true;

        // نمایش لودر
        const loader = document.getElementById('loader');
        loader.classList.add('active');
    }
    </script>
</body>

</html>
