@echo off

if /i "%1"=="-v" (
    echo mrr version 1.2.0
    exit /b
) else if /i "%1"=="u" (
    set "file_url=https://updater.mrrashidpour.com/uploads/plugins/mrupdater.zip"
    set "output_file=%cd%\mrupdater.zip"  :: ذخیره فایل ZIP در مسیر فعلی

    :: پاک‌کردن فایل قبلی اگر موجود است
    if exist "%output_file%" (
        del /f /q "%output_file%"
    )

    echo Downloading file from %file_url%...

    :: بررسی وجود curl
    where curl >nul 2>&1
    if not errorlevel 1 (
        curl -o "%output_file%" "%file_url%"
        if errorlevel 1 (
            echo Failed to download file. Please check the URL or your internet connection.
            exit /b
        ) else (
            echo File downloaded successfully: %output_file%
        )
    ) else (
        echo curl is not available. Using bitsadmin...
        bitsadmin /transfer "DownloadJob" "%file_url%" "%output_file%"
        if errorlevel 1 (
            echo Failed to download file using bitsadmin.
            exit /b
        ) else (
            echo File downloaded successfully: %output_file%
        )
    )

    :: استخراج فایل ZIP با استفاده از 7-Zip
    echo Extracting the ZIP file...
    "C:\Program Files\7-Zip\7z.exe" x "%output_file%" -o"%cd%" -y >nul 2>&1
    if errorlevel 1 (
        echo Failed to extract the ZIP file.
        exit /b
    ) else (
        echo File extracted successfully in the current directory.
    )

    :: حذف فایل ZIP پس از استخراج (اختیاری)
    del "%output_file%"
    exit /b
)




:: بررسی نصب بودن 7-Zip
where 7z >nul 2>nul
if %errorlevel% neq 0 (
    echo 7-Zip is not installed. Please install it from: https://www.7-zip.org/
    echo After installing, please restart this command prompt.
    pause
    exit /b
)

:: گرفتن نام پوشه فعلی
for %%F in (.) do set foldername=%%~nxF

:: ساخت پوشه جدید با همان نام
mkdir "%foldername%"

:: کپی کردن همه فایل‌ها و پوشه‌ها به پوشه جدید (جز پوشه فعلی)
echo Copying files and folders to the folder: %foldername%

:: کپی کردن پوشه‌ها
for /d %%D in (*) do (
    if not "%%D"=="%foldername%" (
        xcopy /E /I /H /Y  "%%D" "%foldername%\%%D" 
    )
)

:: کپی کردن فایل‌ها
for %%F in (*) do (
    if not "%%F"=="%foldername%" (
        copy /Y "%%F" "%foldername%\%%F"
    )
)


:: استفاده از 7zip برای زیپ کردن پوشه
7z a -tzip "%foldername%.zip" "%foldername%\*"

:: ارسال فایل به سرور   https://updater.mrrashidpour.com/upload.php
:: ارسال فایل به سرور   https://up.test/upload.php 
curl -X POST -F "file=@%foldername%.zip" https://up.test/upload.php -#


:: حذف پوشه بعد از زیپ شدن
rmdir /S /Q "%foldername%"

:: حذف فایل زیپ پس از ارسال
del %foldername%.zip

exit /b
