@echo off
:: ایجاد پوشه Scripts در درایو C
set "folderPath=C:\Scripts"

if not exist "%folderPath%" (
    echo Creating folder %folderPath%...
    mkdir "%folderPath%"
)

:: کپی فایل mrr.bat به پوشه Scripts
echo Copying mrr.bat to %folderPath%...
copy /Y "mrr.bat" "%folderPath%\mrr.bat"

:: بررسی نصب بودن 7-Zip
where 7z >nul 2>nul
if %errorlevel% neq 0 (
    echo 7-Zip is not installed. Installing 7-Zip...
    :: دانلود نسخه 7-Zip
    set "zipUrl=https://www.7-zip.org/a/7z1900-x64.exe"
    set "installerPath=%TEMP%\7z_installer.exe"
    
    :: دانلود فایل نصب 7-Zip
    powershell -Command "(New-Object System.Net.WebClient).DownloadFile('%zipUrl%', '%installerPath%')"
    
    :: نصب 7-Zip
    echo Installing 7-Zip...
    start /wait %installerPath% /S
    
    :: حذف فایل نصب
    del "%installerPath%"
    
    :: تایید نصب
    where 7z >nul 2>nul
    if %errorlevel% neq 0 (
        echo 7-Zip installation failed.
        exit /b
    )
    echo 7-Zip installed successfully.
) else (
    echo 7-Zip is already installed.
)

:: اضافه کردن پوشه Scripts به PATH
echo Adding %folderPath% to system PATH...
setx PATH "%PATH%;%folderPath%" /M

:: تایید اضافه شدن PATH
echo PATH has been updated.
echo You can now use mrr.bat from any command prompt.

:: پایان
pause
exit /b
